IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[CP_Cobros_Realizados]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [CP_Cobros_Realizados] 
END
GO

CREATE PROCEDURE [dbo].[CP_Cobros_Realizados] 
	 @Filtrar_Fecha TINYINT 
	,@Fecha_Desde DateTime 
	,@Fecha_Hasta DateTime
	,@Id_cliente  INT
	,@Id_Cobrador Varchar(10)
	,@Id_Periodo_Caja INT


 
AS 
BEGIN
SET NOCOUNT ON
DECLARE @Sql		VARCHAR(MAX)
DECLARE @SqlSaldo	VARCHAR(MAX)
DECLARE @SqlSelect	VARCHAR(MAX)
DECLARE @SqlFrom	VARCHAR(MAX)
DECLARE @SqlWhere	VARCHAR(MAX)
DECLARE @SqlGroup	VARCHAR(MAX)

CREATE TABLE #Cobros_Realizados  (
			 Fecha DATETIME
			,Descripcion VARCHAR(25)
			,Id_Trans INT
			,Nro_Cuota SMALLINT
			,Id_cliente INT
			,Razon_Social CHAR(100)
			,Importe DECIMAL(16,2)
			,Id_Tipo_Cbte Char(4)
			,Comprobante_Nro INT
			,Id_Periodo_Caja INT
			,Id_Cobrador Varchar(10)
			,Nombre_Cobrador CHAR(100)
			,Id_Interno INT IDENTITY(1,1)
		)

SET @SqlSelect = 'SELECT k.FECHA as Fecha,
						 k.Descripcion as Descripcion,
						 k.Id_Trans as Id_Trans,
						 k.Nro_Cuota as Nro_Cuota,
						 k.Id_cliente as Id_Cliente,
						 UPPER(CL.Razon_Social) as Razon_Social,
						 K.Importe * -1 as Importe,
						 C.Id_Tipo_Cbte as Id_Tipo_Cbte,
						 C.Comprobante_Nro as Comprobante_Nro,
						 M.Id_Periodo_Caja as Id_Periodo_Caja,
						 UPPER(CL.id_COBRADOR) as Id_Cobrador,
						 V.Descripcion as Nombre_Cobrador'


SET @SqlFrom = ' FROM  Cbtes C , Clientes_Ctacte K, Clientes CL,  Cbtes_Tipos T,  Vendedores V, Cajas_Mov M '
----------------------------------------------------------------------------------------------------------------------
SET @SqlWhere = ' WHERE c.id_trans = k.id_trans 
                        AND K.ID_CLIENTE = CL.ID_CLIENTE
						AND C.ID_TIPO_CBTE = T.ID_TIPO_CBTE
						AND CL.ID_COBRADOR = V.ID_VENDEDOR 
						AND K.ID_ESTADO_CBTE IN (2,4)
						AND T.COMPROMETE_RECIBOS IN (1,-1)
						AND K.ID_TRANS = M.ID_TRANS '
				
					 
IF @Id_cliente <> 0
  BEGIN
	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND C.Id_cliente  = ' +  cast(@id_Cliente  as varchar(12))
  END

IF ISNULL(@Id_Cobrador,'') <> ''
	BEGIN
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND CL.Id_Cobrador = ''' + @Id_Cobrador + ''''
	END

IF @Id_Periodo_Caja <> 0
  BEGIN
	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND M.Id_Periodo_Caja  = ' +  cast(@Id_Periodo_Caja  as varchar(12))
  END


IF ISNULL(@Filtrar_Fecha,0) <> 0
BEGIN
	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND k.FECHA_VENCE >= '''+ CONVERT(VARCHAR(8),@Fecha_Desde,112) +''''

	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND k.FECHA_VENCE < '''+ CONVERT(VARCHAR(8),@Fecha_HASTA+1,112) +''''
END
----------------------------------------------------------------------------------------------------------------------
SET @SqlGroup = ' ORDER BY k.id_cliente,k.FECHA '


SET @Sql = @SqlSelect +' '+ @SqlFrom + ' ' + @SqlWhere + ' ' + @SqlGroup 
PRINT @Sql
--EXECUTE (@Sql) 

CREATE INDEX IX_Cobros_Realizados____ ON  #Cobros_Realizados (Id_Interno)

INSERT INTO #Cobros_Realizados
EXEC(@sql)

SELECT * FROM #Cobros_Realizados

DROP TABLE #Cobros_Realizados

END

-- exec [CP_Cobros_Realizados] 1,'20201101','20201130',103,'',0

-- exec [CP_Cobros_Realizados] 1,'20201101','20201130',0,'',0




